//
//  DetailsUserTransactionViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 07.03.23.
//

import UIKit




class UserTransactionDetailsViewController : UIViewController {
    
    
    
    @IBOutlet var transactionRecipientHeaderLabel: UILabel!
    
    
    @IBOutlet var purposeHeaderLabel: UILabel!
    @IBOutlet var amountHeaderLabel: UILabel!
    
    
    @IBOutlet var userTransactionRecipientLabel: UILabel!
    @IBOutlet var userTransactionIBANLabel: UILabel!
    @IBOutlet var userTransactionAmountLabel: UILabel!
    @IBOutlet var userTransactionPurposeLabel: UILabel!
    
    
    @IBOutlet var transactionFromHeaderLabel: UILabel!
    
    
    @IBOutlet var giroAccountDetailsLabel: UILabel!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.black,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        self.navigationController?.navigationBar.titleTextAttributes = [NSAttributedString.Key.foregroundColor: UIColor.black]
        
        transactionRecipientHeaderLabel.font = Fonts.heavyFontWithSize(size: 18)
        
        userTransactionRecipientLabel.font = Fonts.mediumFontWithSize(size: 17)
        userTransactionRecipientLabel.textColor = .black
        userTransactionIBANLabel.font = Fonts.mediumFontWithSize(size: 16)
        userTransactionIBANLabel.textColor = .black
        
        amountHeaderLabel.font = Fonts.heavyFontWithSize(size: 18)
        userTransactionAmountLabel.font = Fonts.mediumFontWithSize(size: 18)
        userTransactionAmountLabel.textColor = .black
        purposeHeaderLabel.font = Fonts.heavyFontWithSize(size: 18)
        userTransactionPurposeLabel.font = Fonts.mediumFontWithSize(size: 16)
        userTransactionPurposeLabel.textColor = .black
        
        transactionFromHeaderLabel.font = Fonts.heavyFontWithSize(size: 18)
        
        let defaults = UserDefaults.standard
        userTransactionRecipientLabel.text = " " + (defaults.string(forKey: "UserTransactionRecipient") ?? "")
        userTransactionIBANLabel.text = " " + (defaults.string(forKey: "userTransactionIBAN") ?? "")
        userTransactionPurposeLabel.text = " " + (defaults.string(forKey: "userTransactionPurpose") ?? "")
        
        
        var transactionSum : String = String(defaults.float(forKey: "userTransactionAmount")).replacingOccurrences(of: ".", with: ",")

        
        // check if already two digits are followd by "," (e.g., xxxxx,xx €)
        if !Utilities.numberFollowedByDotAndExactTwoDigits(transactionSum) {
            transactionSum = transactionSum + "0"
        }
        


        
        if transactionSum.count >= 7 {
            transactionSum.insert(".", at: (transactionSum.index(transactionSum.startIndex, offsetBy: 1)))
        }
        
        userTransactionAmountLabel.text = " - " + transactionSum + " €"
        
        
        showGiroAccount()
        
        //self.view.backgroundColor = .clear
    }
    
    func showGiroAccount() {
        
        
        giroAccountDetailsLabel.layer.cornerRadius = 10
        giroAccountDetailsLabel.layer.masksToBounds = true
        giroAccountDetailsLabel.layer.maskedCorners = [.layerMinXMinYCorner, .layerMaxXMinYCorner, .layerMinXMaxYCorner, .layerMaxXMaxYCorner]
        giroAccountDetailsLabel.layer.borderWidth = 2.0
        giroAccountDetailsLabel.layer.borderColor = UIColor.init(red: 30/255, green: 91/255, blue: 158/255, alpha: 1).cgColor
        
        
        
        giroAccountDetailsLabel.font = Fonts.mediumFontWithSize(size: 16)
        
        giroAccountDetailsLabel.numberOfLines = 0
        giroAccountDetailsLabel.lineBreakMode = .byTruncatingTail
        let giroDetails = NSMutableAttributedString.init(string: "   LightBanking Giro Premium\n   DE12 2707 0369 1128 5096 19")
        
        giroDetails.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 16),
                                    NSAttributedString.Key.foregroundColor: UIColor.darkGray],
                                   range: NSMakeRange(0, 28)) // 25
        
        giroAccountDetailsLabel.attributedText = giroDetails
    }
    
    
    @IBAction func backButton(_ sender: Any) {
        self.dismiss(animated: true)
    }
    
}
